/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.changepw;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import java.util.Date;

public class PWManagerService
extends Tasklet {
    private static final String TRACE_MASKT = "XCPWSRVT";
    public static final short SERVER_RUN_ERROR = 2;
    static final String SERVICE_OPERATION = "operation";
    static final String OPERATION_GET_USER_INFO = "getUserInfo";
    static final String RESPONSE_STRICT_RULES = "strictRules";
    static final String RESPONSE_PW_CASE_SENSITIVE = "pwCaseSensitive";
    static final String RESPONSE_USER_IS_SERVICE = "userIsServiceRole";
    static final String OPERATION_IS_PASSWORD_CORRECT = "isPasswordCorrect";
    static final String REQUEST_PASSWORD = "password";
    static final String RESPONSE_PASSWORD_CORRECT = "correct";
    static final String OPERATION_SET_PASSWORD = "setPassword";

    public void init(Object initData) throws TaskletException {
    }

    public void service(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        taskletResponse.noAction();
        if (taskletRequest.isInitialRequest()) {
            return;
        }
        String operation = (String)taskletRequest.getData(SERVICE_OPERATION);
        if (operation == null) {
            throw new TaskletException("Missing operation");
        }
        if (operation.equals(OPERATION_GET_USER_INFO)) {
            this.getUserInfo(taskletRequest, taskletResponse);
        } else if (operation.equals(OPERATION_IS_PASSWORD_CORRECT)) {
            this.isPasswordCorrect(taskletRequest, taskletResponse);
        } else if (operation.equals(OPERATION_SET_PASSWORD)) {
            this.setPassword(taskletRequest, taskletResponse);
        } else {
            throw new TaskletException("Unknown operation \"" + operation + '\"');
        }
    }

    private void getUserInfo(TaskletRequest taskletRequest, TaskletResponse taskletResponse) {
        User user = User.getUser();
        taskletResponse.setData(RESPONSE_STRICT_RULES, new Boolean(user.isPasswordRulesEnforced()));
        taskletResponse.setData(RESPONSE_PW_CASE_SENSITIVE, new Boolean(user.isCaseSensitive()));
        taskletResponse.setData(RESPONSE_USER_IS_SERVICE, new Boolean(user.hasAuth("base.rolegroup.service")));
    }

    private void isPasswordCorrect(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        String password = (String)taskletRequest.getData(REQUEST_PASSWORD);
        if (password == null) {
            throw new TaskletException("Missing password");
        }
        taskletResponse.setData(RESPONSE_PASSWORD_CORRECT, new Boolean(User.getUser().isPasswordValid(password)));
    }

    private void setPassword(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        String password = (String)taskletRequest.getData(REQUEST_PASSWORD);
        if (password == null) {
            throw new TaskletException("Missing password");
        }
        User user = User.getUser();
        user.setPassword(password);
        if (user.isPasswordRulesEnforced()) {
            user.setExpirationStartDate(new Date().getTime());
        }
    }

    public void logException(Throwable throwable) {
        FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ChangePWTask");
        new FrameworkLog(classLogInfo, 2, throwable).log();
    }
}

